/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkVertexType;
import net.coderbot.iris.gl.blending.AlphaTest;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.gl.blending.BufferBlendOverride;
import net.coderbot.iris.gl.framebuffer.GlFramebuffer;
import net.coderbot.iris.gl.program.ProgramImages;
import net.coderbot.iris.gl.program.ProgramSamplers;
import net.coderbot.iris.gl.program.ProgramUniforms;
import net.coderbot.iris.pipeline.ShaderPrinter;
import net.coderbot.iris.pipeline.WorldRenderingPipeline;
import net.coderbot.iris.pipeline.newshader.AlphaTests;
import net.coderbot.iris.pipeline.newshader.FogMode;
import net.coderbot.iris.pipeline.newshader.ShaderAttributeInputs;
import net.coderbot.iris.pipeline.transform.PatchShaderType;
import net.coderbot.iris.pipeline.transform.TransformPatcher;
import net.coderbot.iris.rendertarget.RenderTargets;
import net.coderbot.iris.shaderpack.ProgramSet;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shaderpack.loading.ProgramId;
import net.coderbot.iris.uniforms.CommonUniforms;
import net.coderbot.iris.uniforms.builtin.BuiltinReplacementUniforms;
import net.coderbot.iris.uniforms.custom.CustomUniforms;
import net.minecraft.class_2960;

public class SodiumTerrainPipeline {
    Optional<String> terrainSolidVertex;
    Optional<String> terrainSolidGeometry;
    Optional<String> terrainSolidFragment;
    GlFramebuffer terrainSolidFramebuffer;
    BlendModeOverride terrainSolidBlendOverride;
    List<BufferBlendOverride> terrainSolidBufferOverrides;
    Optional<String> terrainCutoutVertex;
    Optional<String> terrainCutoutGeometry;
    Optional<String> terrainCutoutFragment;
    GlFramebuffer terrainCutoutFramebuffer;
    BlendModeOverride terrainCutoutBlendOverride;
    List<BufferBlendOverride> terrainCutoutBufferOverrides;
    Optional<AlphaTest> terrainCutoutAlpha;
    Optional<String> translucentVertex;
    Optional<String> translucentGeometry;
    Optional<String> translucentFragment;
    GlFramebuffer translucentFramebuffer;
    BlendModeOverride translucentBlendOverride;
    List<BufferBlendOverride> translucentBufferOverrides;
    Optional<AlphaTest> translucentAlpha;
    Optional<String> shadowVertex;
    Optional<String> shadowGeometry;
    Optional<String> shadowFragment;
    Optional<String> shadowCutoutFragment;
    GlFramebuffer shadowFramebuffer;
    BlendModeOverride shadowBlendOverride = BlendModeOverride.OFF;
    List<BufferBlendOverride> shadowBufferOverrides;
    Optional<AlphaTest> shadowAlpha;
    private static String defaultVertex = "#version 330 core\n\nin ivec2 a_LightCoord;\nin vec4 a_Color;\nin vec2 a_TexCoord;\nin uvec4 a_PosId;\nuniform mat4 iris_ProjectionMatrix;\nuniform int fogShape;\nuniform mat4 iris_ModelViewMatrix;\nuniform vec3 u_RegionOffset;\nvec3 _vert_position;\nvec2 _vert_tex_diffuse_coord;\nivec2 _vert_tex_light_coord;\nvec4 _vert_color;\nuint _draw_id;\nuint _material_params;\nout float v_FragDistance;\n\n\nconst int FOG_SHAPE_SPHERICAL = 0;\nconst int FOG_SHAPE_CYLINDRICAL = 1;\n\nvec4 _linearFog(vec4 fragColor, float fragDistance, vec4 fogColor, float fogStart, float fogEnd) {\n    float factor = smoothstep(fogStart, fogEnd, fragDistance * fogColor.a); // alpha value of fog is used as a weight\n    vec3 blended = mix(fragColor.rgb, fogColor.rgb, factor);\n\n    return vec4(blended, fragColor.a); // alpha value of fragment cannot be modified\n}\n\nfloat getFragDistance(int fogShape, vec3 position) {\n    // Use the maximum of the horizontal and vertical distance to get cylindrical fog if fog shape is cylindrical\n    switch (fogShape) {\n        case FOG_SHAPE_SPHERICAL: return length(position);\n        case FOG_SHAPE_CYLINDRICAL: return max(length(position.xz), abs(position.y));\n        default: return length(position); // This shouldn't be possible to get, but return a sane value just in case\n    }\n}\n\nout vec4 v_ColorModulator;\nout vec2 v_TexCoord;\nout float v_MaterialMipBias;\nout float v_MaterialAlphaCutoff;\nconst uint MATERIAL_USE_MIP_OFFSET = 0u;\nconst uint MATERIAL_ALPHA_CUTOFF_OFFSET = 1u;\n\nfloat _material_mip_bias(uint material) {\n\treturn ((material >> MATERIAL_USE_MIP_OFFSET) & 1u) != 0u ? 0.0f : -4.0f;\n}\n\nconst float[4] ALPHA_CUTOFF = float[4](0.0, 0.1, 0.5, 1.0);\n\nfloat _material_alpha_cutoff(uint material) {\n    return ALPHA_CUTOFF[(material >> MATERIAL_ALPHA_CUTOFF_OFFSET) & 3u];\n}\n\nvoid _vert_init() {\n\t_vert_position = (vec3(a_PosId.xyz) * 4.8828125E-4f + -8.0f);\n\t_vert_tex_diffuse_coord = (a_TexCoord * 1.52587891E-5f);\n\t_vert_tex_light_coord = a_LightCoord;\n\t_vert_color = a_Color;\n\t_draw_id = (a_PosId.w >> 8u) & 0xffu;\n\t_material_params = (a_PosId.w >> 0u) & 0xFFu;\n}\nuvec3 _get_relative_chunk_coord(uint pos) {\n\treturn uvec3(pos) >> uvec3(5u, 0u, 2u) & uvec3(7u, 3u, 7u);\n}\nvec3 _get_draw_translation(uint pos) {\n\treturn _get_relative_chunk_coord(pos) * vec3(16.0f);\n}\nvec4 getVertexPosition() {\n\treturn vec4(_vert_position + u_RegionOffset + _get_draw_translation(_draw_id), 1.0f);\n}\n\nuniform sampler2D lightmap; // The light map texture\n\nvec3 _sample_lightmap(ivec2 uv) {\n    return texture(lightmap, clamp(uv / 256.0, vec2(0.5 / 16.0), vec2(15.5 / 16.0))).rgb;\n}\n\n\nvoid main() {\n    _vert_init();\n\n    // Transform the chunk-local vertex position into world model space\n    vec3 translation = u_RegionOffset + _get_draw_translation(_draw_id);\n    vec3 position = _vert_position + translation;\n\n    v_FragDistance = getFragDistance(fogShape, position);\n\n    // Transform the vertex position into model-view-projection space\n    gl_Position = iris_ProjectionMatrix * iris_ModelViewMatrix * vec4(position, 1.0);\n\n    v_ColorModulator = vec4((_vert_color.rgb * _vert_color.a), 1) * vec4(_sample_lightmap(_vert_tex_light_coord), 1.0);\n    v_TexCoord = _vert_tex_diffuse_coord;\n\n    v_MaterialMipBias = _material_mip_bias(_material_params);\n    v_MaterialAlphaCutoff = _material_alpha_cutoff(_material_params);\n}\n";
    private static String defaultFragment = "#version 330 core\n\nconst int FOG_SHAPE_SPHERICAL = 0;\nconst int FOG_SHAPE_CYLINDRICAL = 1;\n\nvec4 _linearFog(vec4 fragColor, float fragDistance, vec4 fogColor, float fogStart, float fogEnd) {\n    float factor = smoothstep(fogStart, fogEnd, fragDistance * fogColor.a); // alpha value of fog is used as a weight\n    vec3 blended = mix(fragColor.rgb, fogColor.rgb, factor);\n\n    return vec4(blended, fragColor.a); // alpha value of fragment cannot be modified\n}\n\nin vec4 v_ColorModulator; // The interpolated vertex color\nin vec2 v_TexCoord; // The interpolated block texture coordinates\n\nin float v_FragDistance; // The fragment's distance from the camera\n\nin float v_MaterialMipBias;\nin float v_MaterialAlphaCutoff;\n\nuniform sampler2D gtexture; // The block atlas texture\n\nuniform vec4 iris_FogColor; // The color of the shader fog\nuniform float iris_FogStart; // The starting position of the shader fog\nuniform float iris_FogEnd; // The ending position of the shader fog\n\nout vec4 out_FragColor; // The output fragment for the color framebuffer\n\nvoid main() {\n    vec4 diffuseColor = texture(gtexture, v_TexCoord, v_MaterialMipBias);\n\n    if (diffuseColor.a < 0.1) {\n        discard;\n    }\n\n    // Modulate the color (used by ambient occlusion and per-vertex colouring)\n    diffuseColor.rgb *= v_ColorModulator.rgb;\n\n    out_FragColor = _linearFog(diffuseColor, v_FragDistance, iris_FogColor, iris_FogStart, iris_FogEnd);\n}\n";
    ProgramSet programSet;
    private final WorldRenderingPipeline parent;
    private final CustomUniforms customUniforms;
    private final IntFunction<ProgramSamplers> createTerrainSamplers;
    private final IntFunction<ProgramSamplers> createShadowSamplers;
    private final IntFunction<ProgramImages> createTerrainImages;
    private final IntFunction<ProgramImages> createShadowImages;
    private static final Supplier<Optional<AlphaTest>> terrainCutoutDefault = () -> Optional.of(AlphaTests.ONE_TENTH_ALPHA);
    private static final Supplier<Optional<AlphaTest>> translucentDefault = () -> Optional.of(AlphaTest.ALWAYS);
    private static final Supplier<Optional<AlphaTest>> shadowDefault = () -> Optional.of(AlphaTests.ONE_TENTH_ALPHA);

    public SodiumTerrainPipeline(WorldRenderingPipeline worldRenderingPipeline, ProgramSet programSet, IntFunction<ProgramSamplers> intFunction, IntFunction<ProgramSamplers> intFunction2, IntFunction<ProgramImages> intFunction3, IntFunction<ProgramImages> intFunction4, RenderTargets renderTargets, ImmutableSet<Integer> immutableSet, ImmutableSet<Integer> immutableSet2, GlFramebuffer glFramebuffer, CustomUniforms customUniforms) {
        this.parent = Objects.requireNonNull(worldRenderingPipeline);
        this.customUniforms = customUniforms;
        Optional<ProgramSource> optional = SodiumTerrainPipeline.first(programSet.getGbuffersTerrainSolid(), programSet.getGbuffersTerrain(), programSet.getGbuffersTexturedLit(), programSet.getGbuffersTextured(), programSet.getGbuffersBasic());
        Optional<ProgramSource> optional2 = SodiumTerrainPipeline.first(programSet.getGbuffersTerrainCutout(), programSet.getGbuffersTerrain(), programSet.getGbuffersTexturedLit(), programSet.getGbuffersTextured(), programSet.getGbuffersBasic());
        Optional<ProgramSource> optional3 = SodiumTerrainPipeline.first(programSet.getGbuffersWater(), optional2);
        this.programSet = programSet;
        this.shadowFramebuffer = glFramebuffer;
        optional.ifPresent(programSource -> {
            this.terrainSolidFramebuffer = renderTargets.createGbufferFramebuffer(immutableSet, programSource.getDirectives().getDrawBuffers());
        });
        optional2.ifPresent(programSource -> {
            this.terrainCutoutFramebuffer = renderTargets.createGbufferFramebuffer(immutableSet, programSource.getDirectives().getDrawBuffers());
        });
        optional3.ifPresent(programSource -> {
            this.translucentFramebuffer = renderTargets.createGbufferFramebuffer(immutableSet2, programSource.getDirectives().getDrawBuffers());
        });
        if (this.terrainSolidFramebuffer == null) {
            this.terrainSolidFramebuffer = renderTargets.createGbufferFramebuffer(immutableSet, new int[]{0});
        }
        if (this.terrainCutoutFramebuffer == null) {
            this.terrainCutoutFramebuffer = renderTargets.createGbufferFramebuffer(immutableSet, new int[]{0});
        }
        if (this.translucentFramebuffer == null) {
            this.translucentFramebuffer = renderTargets.createGbufferFramebuffer(immutableSet2, new int[]{0});
        }
        this.createTerrainSamplers = intFunction;
        this.createShadowSamplers = intFunction2;
        this.createTerrainImages = intFunction3;
        this.createShadowImages = intFunction4;
    }

    public void patchShaders(ChunkVertexType chunkVertexType) {
        ShaderAttributeInputs shaderAttributeInputs = new ShaderAttributeInputs(true, true, false, true, true);
        Optional<ProgramSource> optional = SodiumTerrainPipeline.first(this.programSet.getGbuffersTerrainSolid(), this.programSet.getGbuffersTerrain(), this.programSet.getGbuffersTexturedLit(), this.programSet.getGbuffersTextured(), this.programSet.getGbuffersBasic());
        Optional<ProgramSource> optional2 = SodiumTerrainPipeline.first(this.programSet.getGbuffersTerrainCutout(), this.programSet.getGbuffersTerrain(), this.programSet.getGbuffersTexturedLit(), this.programSet.getGbuffersTextured(), this.programSet.getGbuffersBasic());
        Optional<ProgramSource> optional3 = SodiumTerrainPipeline.first(this.programSet.getGbuffersWater(), optional2);
        optional.ifPresentOrElse(programSource -> {
            this.terrainSolidBlendOverride = programSource.getDirectives().getBlendModeOverride().orElse(ProgramId.Terrain.getBlendModeOverride());
            this.terrainSolidBufferOverrides = new ArrayList<BufferBlendOverride>();
            programSource.getDirectives().getBufferBlendOverrides().forEach(bufferBlendInformation -> {
                int n = Ints.indexOf((int[])programSource.getDirectives().getDrawBuffers(), (int)bufferBlendInformation.getIndex());
                if (n > -1) {
                    this.terrainSolidBufferOverrides.add(new BufferBlendOverride(n, bufferBlendInformation.getBlendMode()));
                }
            });
            Map<PatchShaderType, String> map = TransformPatcher.patchSodium(programSource.getName(), programSource.getVertexSource().orElse(null), programSource.getGeometrySource().orElse(null), programSource.getFragmentSource().orElse(null), AlphaTest.ALWAYS, shaderAttributeInputs, this.parent.getTextureMap());
            this.terrainSolidVertex = Optional.ofNullable(map.get((Object)PatchShaderType.VERTEX));
            this.terrainSolidGeometry = Optional.ofNullable(map.get((Object)PatchShaderType.GEOMETRY));
            this.terrainSolidFragment = Optional.ofNullable(map.get((Object)PatchShaderType.FRAGMENT));
            ShaderPrinter.printProgram(programSource.getName() + "_sodium_solid").addSources(map).print();
        }, () -> {
            this.terrainSolidBlendOverride = null;
            this.terrainSolidBufferOverrides = Collections.emptyList();
            this.terrainSolidVertex = Optional.of(defaultVertex);
            this.terrainSolidGeometry = Optional.empty();
            this.terrainSolidFragment = Optional.of(defaultFragment);
        });
        optional2.ifPresentOrElse(programSource -> {
            this.terrainCutoutBlendOverride = programSource.getDirectives().getBlendModeOverride().orElse(ProgramId.Terrain.getBlendModeOverride());
            this.terrainCutoutBufferOverrides = new ArrayList<BufferBlendOverride>();
            programSource.getDirectives().getBufferBlendOverrides().forEach(bufferBlendInformation -> {
                int n = Ints.indexOf((int[])programSource.getDirectives().getDrawBuffers(), (int)bufferBlendInformation.getIndex());
                if (n > -1) {
                    this.terrainCutoutBufferOverrides.add(new BufferBlendOverride(n, bufferBlendInformation.getBlendMode()));
                }
            });
            this.terrainCutoutAlpha = programSource.getDirectives().getAlphaTestOverride().or(terrainCutoutDefault);
            Map<PatchShaderType, String> map = TransformPatcher.patchSodium(programSource.getName(), programSource.getVertexSource().orElse(null), programSource.getGeometrySource().orElse(null), programSource.getFragmentSource().orElse(null), this.terrainCutoutAlpha.orElse(AlphaTests.ONE_TENTH_ALPHA), shaderAttributeInputs, this.parent.getTextureMap());
            this.terrainCutoutVertex = Optional.ofNullable(map.get((Object)PatchShaderType.VERTEX));
            this.terrainCutoutGeometry = Optional.ofNullable(map.get((Object)PatchShaderType.GEOMETRY));
            this.terrainCutoutFragment = Optional.ofNullable(map.get((Object)PatchShaderType.FRAGMENT));
            ShaderPrinter.printProgram(programSource.getName() + "_sodium_cutout").addSources(map).print();
        }, () -> {
            this.terrainCutoutBlendOverride = null;
            this.terrainCutoutBufferOverrides = Collections.emptyList();
            this.terrainCutoutAlpha = terrainCutoutDefault.get();
            this.terrainCutoutVertex = Optional.of(defaultVertex);
            this.terrainCutoutGeometry = Optional.empty();
            this.terrainCutoutFragment = Optional.of(defaultFragment);
        });
        optional3.ifPresentOrElse(programSource -> {
            this.translucentBlendOverride = programSource.getDirectives().getBlendModeOverride().orElse(ProgramId.Water.getBlendModeOverride());
            this.translucentBufferOverrides = new ArrayList<BufferBlendOverride>();
            programSource.getDirectives().getBufferBlendOverrides().forEach(bufferBlendInformation -> {
                int n = Ints.indexOf((int[])programSource.getDirectives().getDrawBuffers(), (int)bufferBlendInformation.getIndex());
                if (n > -1) {
                    this.translucentBufferOverrides.add(new BufferBlendOverride(n, bufferBlendInformation.getBlendMode()));
                }
            });
            this.translucentAlpha = programSource.getDirectives().getAlphaTestOverride().or(translucentDefault);
            Map<PatchShaderType, String> map = TransformPatcher.patchSodium(programSource.getName(), programSource.getVertexSource().orElse(null), programSource.getGeometrySource().orElse(null), programSource.getFragmentSource().orElse(null), this.translucentAlpha.orElse(AlphaTest.ALWAYS), shaderAttributeInputs, this.parent.getTextureMap());
            this.translucentVertex = Optional.ofNullable(map.get((Object)PatchShaderType.VERTEX));
            this.translucentGeometry = Optional.ofNullable(map.get((Object)PatchShaderType.GEOMETRY));
            this.translucentFragment = Optional.ofNullable(map.get((Object)PatchShaderType.FRAGMENT));
            ShaderPrinter.printProgram(programSource.getName() + "_sodium").addSources(map).print();
        }, () -> {
            this.translucentBlendOverride = null;
            this.translucentBufferOverrides = Collections.emptyList();
            this.translucentAlpha = translucentDefault.get();
            this.translucentVertex = Optional.of(defaultVertex);
            this.translucentGeometry = Optional.empty();
            this.translucentFragment = Optional.of(defaultFragment);
        });
        this.programSet.getShadow().ifPresentOrElse(programSource -> {
            this.shadowBlendOverride = programSource.getDirectives().getBlendModeOverride().orElse(ProgramId.Shadow.getBlendModeOverride());
            this.shadowBufferOverrides = new ArrayList<BufferBlendOverride>();
            programSource.getDirectives().getBufferBlendOverrides().forEach(bufferBlendInformation -> {
                int n = Ints.indexOf((int[])programSource.getDirectives().getDrawBuffers(), (int)bufferBlendInformation.getIndex());
                if (n > -1) {
                    this.shadowBufferOverrides.add(new BufferBlendOverride(n, bufferBlendInformation.getBlendMode()));
                }
            });
            this.shadowAlpha = programSource.getDirectives().getAlphaTestOverride().or(shadowDefault);
            Map<PatchShaderType, String> map = TransformPatcher.patchSodium(programSource.getName(), programSource.getVertexSource().orElse(null), programSource.getGeometrySource().orElse(null), programSource.getFragmentSource().orElse(null), AlphaTest.ALWAYS, shaderAttributeInputs, this.parent.getTextureMap());
            Map<PatchShaderType, String> map2 = TransformPatcher.patchSodium(programSource.getName(), programSource.getVertexSource().orElse(null), programSource.getGeometrySource().orElse(null), programSource.getFragmentSource().orElse(null), this.shadowAlpha.get(), shaderAttributeInputs, this.parent.getTextureMap());
            this.shadowVertex = Optional.ofNullable(map.get((Object)PatchShaderType.VERTEX));
            this.shadowGeometry = Optional.ofNullable(map.get((Object)PatchShaderType.GEOMETRY));
            this.shadowCutoutFragment = Optional.ofNullable(map2.get((Object)PatchShaderType.FRAGMENT));
            this.shadowFragment = Optional.ofNullable(map.get((Object)PatchShaderType.FRAGMENT));
            ShaderPrinter.printProgram(programSource.getName() + "_sodium").addSources(map).setName(programSource.getName() + "_sodium_cutout").addSource(PatchShaderType.FRAGMENT, this.shadowCutoutFragment.orElse(null)).print();
        }, () -> {
            this.shadowBlendOverride = null;
            this.shadowBufferOverrides = Collections.emptyList();
            this.shadowAlpha = shadowDefault.get();
            this.shadowVertex = Optional.empty();
            this.shadowGeometry = Optional.empty();
            this.shadowCutoutFragment = Optional.empty();
            this.shadowFragment = Optional.empty();
        });
    }

    public Optional<String> getTerrainSolidVertexShaderSource() {
        return this.terrainSolidVertex;
    }

    public Optional<String> getTerrainSolidGeometryShaderSource() {
        return this.terrainSolidGeometry;
    }

    public Optional<String> getTerrainSolidFragmentShaderSource() {
        return this.terrainSolidFragment;
    }

    public Optional<String> getTerrainCutoutVertexShaderSource() {
        return this.terrainCutoutVertex;
    }

    public Optional<String> getTerrainCutoutGeometryShaderSource() {
        return this.terrainCutoutGeometry;
    }

    public Optional<String> getTerrainCutoutFragmentShaderSource() {
        return this.terrainCutoutFragment;
    }

    public GlFramebuffer getTerrainSolidFramebuffer() {
        return this.terrainSolidFramebuffer;
    }

    public GlFramebuffer getTerrainCutoutFramebuffer() {
        return this.terrainCutoutFramebuffer;
    }

    public BlendModeOverride getTerrainSolidBlendOverride() {
        return this.terrainSolidBlendOverride;
    }

    public List<BufferBlendOverride> getTerrainSolidBufferOverrides() {
        return this.terrainSolidBufferOverrides;
    }

    public BlendModeOverride getTerrainCutoutBlendOverride() {
        return this.terrainCutoutBlendOverride;
    }

    public List<BufferBlendOverride> getTerrainCutoutBufferOverrides() {
        return this.terrainCutoutBufferOverrides;
    }

    public Optional<AlphaTest> getTerrainCutoutAlpha() {
        return this.terrainCutoutAlpha;
    }

    public Optional<String> getTranslucentVertexShaderSource() {
        return this.translucentVertex;
    }

    public Optional<String> getTranslucentGeometryShaderSource() {
        return this.translucentGeometry;
    }

    public Optional<String> getTranslucentFragmentShaderSource() {
        return this.translucentFragment;
    }

    public GlFramebuffer getTranslucentFramebuffer() {
        return this.translucentFramebuffer;
    }

    public BlendModeOverride getTranslucentBlendOverride() {
        return this.translucentBlendOverride;
    }

    public List<BufferBlendOverride> getTranslucentBufferOverrides() {
        return this.translucentBufferOverrides;
    }

    public Optional<AlphaTest> getTranslucentAlpha() {
        return this.translucentAlpha;
    }

    public Optional<String> getShadowVertexShaderSource() {
        return this.shadowVertex;
    }

    public Optional<String> getShadowGeometryShaderSource() {
        return this.shadowGeometry;
    }

    public Optional<String> getShadowFragmentShaderSource() {
        return this.shadowFragment;
    }

    public Optional<String> getShadowCutoutFragmentShaderSource() {
        return this.shadowCutoutFragment;
    }

    public GlFramebuffer getShadowFramebuffer() {
        return this.shadowFramebuffer;
    }

    public BlendModeOverride getShadowBlendOverride() {
        return this.shadowBlendOverride;
    }

    public List<BufferBlendOverride> getShadowBufferOverrides() {
        return this.shadowBufferOverrides;
    }

    public Optional<AlphaTest> getShadowAlpha() {
        return this.shadowAlpha;
    }

    public ProgramUniforms.Builder initUniforms(int n) {
        ProgramUniforms.Builder builder = ProgramUniforms.builder("<sodium shaders>", n);
        CommonUniforms.addDynamicUniforms(builder, FogMode.PER_VERTEX);
        this.customUniforms.assignTo(builder);
        BuiltinReplacementUniforms.addBuiltinReplacementUniforms(builder);
        return builder;
    }

    public boolean hasShadowPass() {
        return this.createShadowSamplers != null;
    }

    public ProgramSamplers initTerrainSamplers(int n) {
        return this.createTerrainSamplers.apply(n);
    }

    public ProgramSamplers initShadowSamplers(int n) {
        return this.createShadowSamplers.apply(n);
    }

    public ProgramImages initTerrainImages(int n) {
        return this.createTerrainImages.apply(n);
    }

    public ProgramImages initShadowImages(int n) {
        return this.createShadowImages.apply(n);
    }

    public CustomUniforms getCustomUniforms() {
        return this.customUniforms;
    }

    @SafeVarargs
    private static <T> Optional<T> first(Optional<T> ... optionalArray) {
        for (Optional<T> optional : optionalArray) {
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    public static String parseSodiumImport(String string) {
        Pattern pattern = Pattern.compile("#import <(?<namespace>.*):(?<path>.*)>");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Malformed import statement (expected format: " + pattern + ")");
        }
        String string2 = matcher.group("namespace");
        String string3 = matcher.group("path");
        class_2960 class_29602 = new class_2960(string2, string3);
        return "";
    }
}

